﻿using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;
using Tessa.Platform;
using Tessa.Roles.Acl;
using Unity;

namespace Tessa.Extensions.AclExamples.Server.Cards
{
    public sealed class AeAclGenerationRuleProvider : IAclGenerationRuleProvider
    {
        #region Fields

        private readonly IUnityContainer container;

        #endregion

        #region Constructors

        public AeAclGenerationRuleProvider(
            IUnityContainer container)
        {
            ThrowIfNull(container);

            this.container = container;
        }

        #endregion

        #region IAclGenerationRuleProvider Implementation

        public ValueTask<IList<IAclGenerationRule>> GetRulesAsync(CancellationToken cancellationToken = default)
        {
            return new ValueTask<IList<IAclGenerationRule>>(new[] { this.container.Resolve<AeAuthorAclGenerationRule>() });
        }

        #endregion
    }
}
