﻿CREATE FUNCTION [AeGetDepartments]
(
	@RoleID uniqueidentifier
)
RETURNS TABLE 
AS
RETURN
(
    WITH
        [RolesCTE] ([ID]) AS
        (
            SELECT @RoleID
            UNION ALL
            SELECT [r].[ID]
            FROM [Roles] AS [r] WITH (NOLOCK)
            INNER JOIN [RolesCTE] AS [t]
                ON [r].[ParentID] = [t].[ID]
            WHERE [r].[TypeID] = 2
        )
    SELECT DISTINCT
        [r].[ID]
    FROM [RolesCTE] AS [r]
)